package gov.va.med.mhv.admin.service.vastaff;

import gov.va.med.mhv.admin.dto.EmployeeSearchResult;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

public interface EmployeeSearchService {

	/**
	 * Execute the searchByUserName operation
	 * Searches user in AD and provides results based on the userName
	 * @param userName
	 */
	List<EmployeeSearchResult> searchByUserName(String userName) throws MHVException;

	/**
	 * Execute the searchByName operation
	 * Searches user in AD and provides results based on the first name and last name
	 * @param firstName
	 * @param lastName
	 */
	List<EmployeeSearchResult> searchByName(String firstName, String lastName) throws MHVException;
}


